
import React from 'react';
import { LoreSummary } from '../types';

interface LoreCardProps {
  lore: LoreSummary;
  fileName: string;
}

export const LoreCard: React.FC<LoreCardProps> = ({ lore, fileName }) => {
  return (
    <div className="bg-slate-800/50 border border-slate-700 rounded-xl p-6 shadow-xl backdrop-blur-sm">
      <div className="flex items-center gap-3 mb-4">
        <i className="fa-solid fa-scroll text-amber-500 text-2xl"></i>
        <h2 className="fantasy-font text-2xl text-amber-100">Campaign Grimoire</h2>
      </div>
      
      <div className="space-y-6">
        <div>
          <h3 className="text-sm font-semibold text-slate-400 uppercase tracking-wider mb-2">Active Chronicle</h3>
          <p className="text-lg font-medium text-slate-200">{fileName}</p>
        </div>

        <div>
          <h3 className="text-sm font-semibold text-slate-400 uppercase tracking-wider mb-2">Aesthetic Essence</h3>
          <p className="text-slate-300 italic">"{lore.visualAesthetic}"</p>
        </div>

        <div>
          <h3 className="text-sm font-semibold text-slate-400 uppercase tracking-wider mb-2">Dominant Themes</h3>
          <div className="flex flex-wrap gap-2">
            {lore.themes.map((theme, i) => (
              <span key={i} className="px-3 py-1 bg-amber-900/30 border border-amber-800/50 text-amber-200 rounded-full text-xs">
                {theme}
              </span>
            ))}
          </div>
        </div>

        <div>
          <h3 className="text-sm font-semibold text-slate-400 uppercase tracking-wider mb-2">Vantage Points</h3>
          <ul className="grid grid-cols-2 gap-2 text-sm text-slate-300">
            {lore.keyLocations.slice(0, 6).map((loc, i) => (
              <li key={i} className="flex items-center gap-2">
                <i className="fa-solid fa-map-pin text-amber-600 text-[10px]"></i>
                {loc}
              </li>
            ))}
          </ul>
        </div>
      </div>
    </div>
  );
};
