
export interface GeneratedImage {
  id: string;
  url: string;
  prompt: string;
  timestamp: number;
  isHighRes?: boolean;
  isEnhancing?: boolean;
}

export interface LoreSummary {
  themes: string[];
  visualAesthetic: string;
  keyLocations: string[];
  summary: string;
}

export interface Chronicle {
  id: string;
  fileName: string;
  lore: LoreSummary;
}

export type GameSystem = 'D&D 2nd Edition' | 'Pathfinder 1st Edition' | 'D&D 5th Edition' | 'Pathfinder 2nd Edition';

export interface GameAdventure {
  title: string;
  hook: string;
  system: GameSystem;
  encounters: {
    name: string;
    description: string;
    difficulty: string;
    mechanics: string;
    environment: {
      terrain: string;
      furniture: string;
      mundaneItems: string;
    };
  }[];
  rewards: string;
}

export interface LibraryState {
  chronicles: Chronicle[];
  activeId: string | null;
  isProcessing: boolean;
}
